//+------------------------------------------------------------------+
//|                                                     Fractals.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//All markets are characterized by the fact that on the most part the prices do not 
//change too much, and only short periods of time (1530 percent) account for trend changes.
//Most lucrative periods are usually the case when market prices change according to a certain 
//trend.
//A Fractal is one of five indicators of Bill Williams trading system, which allows to detect 
//the bottom or the top.
//Fractal Technical Indicator it is a series of at least five successive bars, with the highest 
//HIGH in the middle, and two lower HIGHs on both sides. The reversing set is a series of at least
//five successive bars, with the lowest LOW in the middle, and two higher LOWs on both sides,
//which correlates to the sell fractal. The fractals are have High and Low values and are 
//indicated with the up and down arrows.
//The fractal needs to be filtrated with the use of Alligator. In other words, you should not 
//close a buy transaction, if the fractal is lower than the Alligators Teeth, and you should not
//close a sell transaction, if the fractal is higher than the Alligators Teeth. After the fractal
//signal has been created and is in force, which is determined by its position beyond the 
//Alligators Mouth, it remains a signal until it gets attacked, or until a more recent fractal
//signal emerges
//
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Orange
#property indicator_color2 LightGoldenrod
//---- input parameters

//---- buffers
double dUpFractalsBuffer[];
double dDownFractalsBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicator buffers mapping  
    SetIndexBuffer(0,dUpFractalsBuffer);
    SetIndexBuffer(1,dDownFractalsBuffer);   
//---- drawing settings
    SetIndexStyle(0,DRAW_ARROW);
    SetIndexArrow(0,119);
    SetIndexStyle(1,DRAW_ARROW);
    SetIndexArrow(1,119);
//----
    SetIndexEmptyValue(0,0.0);
    SetIndexEmptyValue(1,0.0);
//---- name for DataWindow
    SetIndexLabel(0,"Fractal Up");
    SetIndexLabel(1,"Fractal Down");
//---- initialization done   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
    int i,nCountedBars;
    nCountedBars=IndicatorCounted();
//---- check for possible errors
    if(nCountedBars<0) return(-1);
//---- last counted bar will be recounted    
    if(nCountedBars<=2)
       i=Bars-nCountedBars-3;
    if(nCountedBars>2)
      {
       nCountedBars--;
       i=Bars-nCountedBars-1;
      }
    while(i>=2)
     {
//----Up and Down Fractals
//----5 bars Fractal
      if(High[i]>High[i+1] && High[i]>High[i+2] && High[i]>High[i-1] && High[i]>High[i-2])
          dUpFractalsBuffer[i]= High[i];
      if(Low[i]<Low[i+1] && Low[i]<Low[i+2] && Low[i]<Low[i-1] && Low[i]<Low[i-2])
        {
          dDownFractalsBuffer[i]= Low[i];
          i--;
          continue;
        }
//----6 bars Fractal
      if((Bars-i-1)>=3)
        {
          if(High[i]==High[i+1] && High[i]>High[i+2] && High[i]>High[i+3] && High[i]>High[i-1] && High[i]>High[i-2])
             dUpFractalsBuffer[i]= High[i];
          if(Low[i]==Low[i+1] && Low[i]<Low[i+2] && Low[i]<Low[i+3] && Low[i]<Low[i-1] && Low[i]<Low[i-2])
            {
              dDownFractalsBuffer[i]= Low[i];
              i--;
              continue;
            }                      
        }         
//----7 bars Fractal
      if((Bars-i-1)>=4)
        {   
         if(High[i]>=High[i+1] && High[i]==High[i+2] && High[i]>High[i+3] && High[i]>High[i+4] && High[i]>High[i-1] && 
            High[i]>High[i-2])
             dUpFractalsBuffer[i]= High[i];
         if(Low[i]<=Low[i+1] && Low[i]==Low[i+2] && Low[i]<Low[i+3] && Low[i]<Low[i+4] && Low[i]<Low[i-1] && 
            Low[i]<Low[i-2])
           {
             dDownFractalsBuffer[i]= Low[i];
             i--;
             continue;
           }                  
        }  
 //----8 bars Fractal                          
      if((Bars-i-1)>=5)
        {   
         if(High[i]>=High[i+1] && High[i]==High[i+2] && High[i]==High[i+3] && High[i]>High[i+4] && High[i]>High[i+5] && 
            High[i]>High[i-1] && High[i]>High[i-2])
             dUpFractalsBuffer[i]= High[i];
         if(Low[i]<=Low[i+1] && Low[i]==Low[i+2] && Low[i]==Low[i+3] && Low[i]<Low[i+4] && Low[i]<Low[i+5] && 
            Low[i]<Low[i-1] && Low[i]<Low[i-2])
           {
             dDownFractalsBuffer[i]= Low[i];
             i--;
             continue;
           }                              
        } 
//----9 bars Fractal                                        
      if((Bars-i-1)>=6)
        {   
         if(High[i]>=High[i+1] && High[i]==High[i+2] && High[i]>=High[i+3] && High[i]==High[i+4] && High[i]>High[i+5] && 
            High[i]>High[i+6] && High[i]>High[i-1] && High[i]>High[i-2])
             dUpFractalsBuffer[i]= High[i];
         if(Low[i]<=Low[i+1] && Low[i]==Low[i+2] && Low[i]<=Low[i+3] && Low[i]==Low[i+4] && Low[i]<Low[i+5] && 
            Low[i]<Low[i+6] && Low[i]<Low[i-1] && Low[i]<Low[i-2])
           {
             dDownFractalsBuffer[i]= Low[i];
             i--;
             continue;
           }                        
        }                                    
      i--;
     }

//----
   return(0);
  }
//+------------------------------------------------------------------+